#include <a_samp>
#include <zcmd>
#include <sscanf2>

#define COLOR_RED        0xFF0000C8
#define COLOR_YELLOW 0xFFFF00AA

#define COLOR_GREEN  0x33CC33C8

enum E_HORSE
{
        Float:hx,
        Float:hy,
        Float:hz,
        order,
        pickup,
        reward
}
new shoecord[][E_HORSE] =
{
{2011.8767,1544.7483,9.4787,0,0,1000},
        {2323.7659,1283.2438,97.5738,2,1,2000},
        {1432.0463,2751.2932,19.5234,3,2,3000},
        {-144.1049,1231.6788,26.2031,4,3,4000},
        {-688.2123,938.3978,13.6328,5,4,5000},
        {-1531.5845,687.4770,133.0514,6,5,6000},
        {-1746.0385,528.1078,33.6328,7,6,7000},
        {-2342.2903,-163.5137,41.6406,8,7,8000},
        {-2397.8435,-246.5068,35.6401,9,8,9000},
        {-2758.2698,-417.5380,7.0309,10,9,10000},
        {-2173.6699,-2366.3496,30.6250,11,10,11000},
        {-1911.3087,-2586.6506,57.0643,12,11,12000},
        {-328.0322,-2130.3245,30.5606,13,12,13000},
        {-345.5536,-1854.0347,-4.9475,14,13,14000},
        {-262.8691,-1638.6805,11.6048,15,14,15000},
        {-369.4187,-1417.4979,25.7266,16,15,16000},
        {141.8222,-1475.9114,28.5270,17,16,17000},
        {388.8241,-1751.6829,20.4459,18,17,18000},
        {389.8570,-2033.2495,7.8359,19,18,19000},
        {715.2880,-1625.7753,2.4297,20,19,20000},
        {1407.0277,-1408.5634,14.2031,21,20,21000},
        {1966.0477,-1205.1957,16.5903,22,21,22000},
        {2113.9241,-1498.7046,10.4219,23,22,23000},
        {1851.5220,-1488.1444,8.8421,24,23,24000},
        {2064.7339,-1585.3751,13.4830,25,24,25000},
        {2431.4189,-2420.6155,13.1867,26,25,26000},
        {2798.5327,-2393.7683,13.9560,27,26,27000},
        {984.4499,2562.9263,10.7498,28,27,28000},
        {490.8186,1309.3688,10.0656,29,28,29000},
        {-425.7174,1390.5726,15.1472,30,29,100000}
};
new hshoe[30],
        horseshoe[MAX_PLAYERS]
;

public OnFilterScriptInit()
{
        for(new i = 0; i < sizeof(shoecord); i++)
        {
                hshoe[shoecord[i][pickup]] = CreatePickup(954, 1, shoecord[i][hx], shoecord[i][hy], shoecord[i][hz], 0);
        }
        return 1;
}

public OnFilterScriptExit()
{
        for(new i = 0; i < sizeof(shoecord); i++)
        {
                DestroyPickup(hshoe[shoecord[i][pickup]]);
        }
        return 1;
}

public OnPlayerConnect(playerid)
{
        SendClientMessage(playerid, -1, "This script uses Jake's Horse Shoe system!");
        horseshoe[playerid] = 0;
        return 1;
}

public OnPlayerDisconnect(playerid, reason)
{
        horseshoe[playerid] = 0;
    return 1;
}

public OnPlayerPickUpPickup(playerid, pickupid)
{
        new str[150], pName[24];
        GetPlayerName(playerid, pName, sizeof(pName));
        if(pickupid == hshoe[0])
        {
                if(horseshoe[playerid] != 0)
                {
                        SendClientMessage(playerid, COLOR_RED, "ERROR: You already collected this horseshoe!");
                        return 1;
                }
                GameTextForPlayer(playerid, "~w~Horseshoe 1 ~r~out ~w~of 30", 2500, 3);
                SendClientMessage(playerid, COLOR_GREEN, "Horseshoe collected! (1/30)");
                horseshoe[playerid] = 1;
                for(new x = 0; x < sizeof(shoecord); x++)
                {
                        GivePlayerMoney(playerid, shoecord[x][reward]);
                }
        }
        if(pickupid == hshoe[29])
        {
            if(horseshoe[playerid] < 29) return SendClientMessage(playerid, COLOR_RED, "ERROR: Collect the horseshoe in order! This is 30/30 horseshoe");
                if(horseshoe[playerid] == 30)
                {
                        SendClientMessage(playerid, COLOR_RED, "ERROR: You've already completed collecting all horseshoe (30/30)!");
                        return 1;
                }
                GameTextForPlayer(playerid, "~w~Horseshoe 30 ~r~out ~w~of 30", 2500, 3);
                SendClientMessage(playerid, COLOR_YELLOW, "All horseshoe collected (30/30)");
                horseshoe[playerid] = 30;
                new moneyreward;
                for(new x = 0; x < sizeof(shoecord); x++)
                {
                        GivePlayerMoney(playerid, shoecord[x][reward]);
                        moneyreward = shoecord[x][reward];
                }
                format(str, sizeof(str), "%s(ID:%d) has collected all horseshoes (30/30)", pName, playerid);
                SendClientMessageToAll(COLOR_YELLOW, str);
                new randscore = random(51);
                SetPlayerScore(playerid, randscore);
                format(str, sizeof(str), "%s receive %i$ + %i score", pName, moneyreward, randscore);
                SendClientMessageToAll(COLOR_GREEN, str);
        }
        for(new i = 0; i < sizeof(shoecord); i++)
        {
                if(pickupid == hshoe[shoecord[i][pickup]])
                {
                    if(horseshoe[playerid] < shoecord[i][order]-1)
                    {
                            format(str, sizeof(str), "ERROR: Collect the horseshoe in order! This is %i/30 horseshoe", shoecord[i][order]);
                                SendClientMessage(playerid, COLOR_RED, str);
                                return 1;
                        }
                        if(horseshoe[playerid] >= shoecord[i][order]) return SendClientMessage(playerid, COLOR_RED, "ERROR: You already collected this horseshoe!");
                        format(str, sizeof(str), "~w~Horseshoe %i ~r~out ~w~of 30", shoecord[i][order]);
                        GameTextForPlayer(playerid, str, 2500, 3);
                        format(str, sizeof(str), "Horseshoe collected! (%i/20)", shoecord[i][order]);
                        SendClientMessage(playerid, COLOR_GREEN, str);
                        horseshoe[playerid] = shoecord[i][order];
                        GivePlayerMoney(playerid, shoecord[i][reward]);
                }
        }
        return 1;
}

CMD:gotohs(playerid, params[])
{
        new str[150], id;
        if(IsPlayerAdmin(playerid))
        {
            if(sscanf(params, "i", id))
            {
                SendClientMessage(playerid, COLOR_RED, "USAGE: /gotohs [0-29]");
                SendClientMessage(playerid, -1, "Example: /gotohs 0 (Teleports you to horseshoe 1)");
                return 1;
            }
            if(id < 0 || id > 29) return SendClientMessage(playerid, COLOR_RED, "ERROR: Invalid Horseshoe ID!");
                if(id == 0)
                {
                    SetCameraBehindPlayer(playerid);
                    SetPlayerPos(playerid, 2011.8767,1544.7483+3,9.4787);
                    SetPlayerInterior(playerid, 0);
                    SetPlayerVirtualWorld(playerid, 0);
                }
                else if(id >= 1)
                {
                    SetCameraBehindPlayer(playerid);
                    SetPlayerPos(playerid, shoecord[id][hx], shoecord[id][hy], shoecord[id][hz]);
                    SetPlayerInterior(playerid, 0);
                    SetPlayerVirtualWorld(playerid, 0);
                }
                format(str, sizeof(str), "Teleported to %i horseshoe!", id);
                SendClientMessage(playerid, COLOR_YELLOW, str);
        }
        else SendClientMessage(playerid, COLOR_RED, ">> You're not RCON Admin! <<");
        return 1;
}
